<p data-nodeid="2712" class="">在第 02 课时，我们简单介绍了解决性能问题常用的一些切入点。本课时我将从计算机资源层面向你讲解，哪些系统组件容易出现性能瓶颈？以及如何判断该系统组件是否达到了瓶颈？</p>


<p data-nodeid="1550">计算机各个组件之间的速度往往很不均衡，比如 CPU 和硬盘，比兔子和乌龟的速度差还大，那么按照我们前面介绍的木桶理论，可以说这个系统是存在着短板的。</p>
<p data-nodeid="1551">当系统存在短板时，就会对性能造成较大的负面影响，比如当 CPU 的负载特别高时，任务就会排队，不能及时执行。而其中，CPU、内存、I/O 这三个系统组件，又往往容易成为瓶颈，所以接下来我会对这三方面分别进行讲解。</p>
<h3 data-nodeid="1552">CPU</h3>
<p data-nodeid="1553">首先介绍计算机中最重要的计算组件中央处理器 CPU，围绕 CPU 一般我们可以：</p>
<ul data-nodeid="1554">
<li data-nodeid="1555">
<p data-nodeid="1556">通过 top 命令，来观测 CPU 的性能；</p>
</li>
<li data-nodeid="1557">
<p data-nodeid="1558">通过负载，评估 CPU 任务执行的排队情况；</p>
</li>
<li data-nodeid="1559">
<p data-nodeid="1560">通过 vmstat，看 CPU 的繁忙程度。</p>
</li>
</ul>
<p data-nodeid="1561">具体情况如下。</p>
<h4 data-nodeid="1562">1.top 命令 —— CPU 性能</h4>
<p data-nodeid="1563">如下图，当进入 top 命令后，按 1 键即可看到每核 CPU 的运行指标和详细性能。</p>
<p data-nodeid="1564"><img src="https://s0.lgstatic.com/i/image/M00/35/51/Ciqc1F8VRhOAOZZkAAIR0PdGn-M708.png" alt="Drawing 0.png" data-nodeid="1712"></p>
<p data-nodeid="1565">CPU 的使用有多个维度的指标，下面分别说明：</p>
<ul data-nodeid="1566">
<li data-nodeid="1567">
<p data-nodeid="1568">us 用户态所占用的 CPU 百分比，即引用程序所耗费的 CPU；</p>
</li>
<li data-nodeid="1569">
<p data-nodeid="1570">sy 内核态所占用的 CPU 百分比，需要配合 vmstat 命令，查看上下文切换是否频繁；</p>
</li>
<li data-nodeid="1571">
<p data-nodeid="1572">ni 高优先级应用所占用的 CPU 百分比；</p>
</li>
<li data-nodeid="1573">
<p data-nodeid="1574">wa 等待 I/O 设备所占用的 CPU 百分比，经常使用它来判断 I/O 问题，过高输入输出设备可能存在非常明显的瓶颈；</p>
</li>
<li data-nodeid="1575">
<p data-nodeid="1576">hi 硬中断所占用的 CPU 百分比；</p>
</li>
<li data-nodeid="1577">
<p data-nodeid="1578">si 软中断所占用的 CPU 百分比；</p>
</li>
<li data-nodeid="1579">
<p data-nodeid="1580">st 在平常的服务器上这个值很少发生变动，因为它测量的是宿主机对虚拟机的影响，即虚拟机等待宿主机 CPU 的时间占比，这在一些超卖的云服务器上，经常发生；</p>
</li>
<li data-nodeid="1581">
<p data-nodeid="1582">id 空闲 CPU 百分比。</p>
</li>
</ul>
<p data-nodeid="1583">一般地，我们比较关注空闲 CPU 的百分比，它可以从整体上体现 CPU 的利用情况。</p>
<h4 data-nodeid="1584">2.负载 —— CPU 任务排队情况</h4>
<p data-nodeid="1585">如果我们评估 CPU 任务执行的排队情况，那么需要通过负载（load）来完成。除了 top 命令，使用 uptime 命令也能够查看负载情况，load 的效果是一样的，分别显示了最近 1min、5min、15min 的数值。</p>
<p data-nodeid="1586"><img src="https://s0.lgstatic.com/i/image/M00/35/52/Ciqc1F8VRlWAKi0UAABUtUrc7Ec737.png" alt="Drawing 1.png" data-nodeid="1727"></p>
<p data-nodeid="1587">如上图所示，以单核操作系统为例，将 CPU 资源抽象成一条单向行驶的马路，则会发生以下三种情况：</p>
<ul data-nodeid="1588">
<li data-nodeid="1589">
<p data-nodeid="1590">马路上的车只有 4 辆，车辆畅通无阻，load 大约是 0.5；</p>
</li>
<li data-nodeid="1591">
<p data-nodeid="1592">马路上的车有 8 辆，正好能首尾相接安全通过，此时 load 大约为 1；</p>
</li>
<li data-nodeid="1593">
<p data-nodeid="1594">马路上的车有 12 辆，除了在马路上的 8 辆车，还有 4 辆等在马路外面，需要排队，此时 load 大约为 1.5。</p>
</li>
</ul>
<p data-nodeid="1595">那 load 为 1 代表的是啥？针对这个问题，误解还是比较多的。</p>
<p data-nodeid="1596">很多人看到 load 的值达到 1，就认为系统负载已经到了极限。这在单核的硬件上没有问题，但在多核硬件上，这种描述就不完全正确，它还与 CPU 的个数有关。例如：</p>
<ul data-nodeid="1597">
<li data-nodeid="1598">
<p data-nodeid="1599">单核的负载达到 1，总 load 的值约为 1；</p>
</li>
<li data-nodeid="1600">
<p data-nodeid="1601">双核的每核负载都达到 1，总 load 约为 2；</p>
</li>
<li data-nodeid="1602">
<p data-nodeid="1603">四核的每核负载都达到 1，总 load 约为 4。</p>
</li>
</ul>
<p data-nodeid="1604">所以，对于一个 load 到了 10，却是 16 核的机器，你的系统还远没有达到负载极限。</p>
<h4 data-nodeid="1605">3.vmstat —— CPU 繁忙程度</h4>
<p data-nodeid="1606">要看 CPU 的繁忙程度，可以通过 vmstat 命令，下图是 vmstat 命令的一些输出信息。</p>
<p data-nodeid="1607"><img src="https://s0.lgstatic.com/i/image/M00/35/8B/CgqCHl8VeDqAOXoUAAL5_mAD--A654.gif" alt="1111.gif" data-nodeid="1742"></p>
<p data-nodeid="1608">比较关注的有下面几列：</p>
<ul data-nodeid="1609">
<li data-nodeid="1610">
<p data-nodeid="1611"><strong data-nodeid="1748">b</strong> 如果系统有负载问题，就可以看一下 b 列（Uninterruptible Sleep），它的意思是等待 I/O，可能是读盘或者写盘动作比较多；</p>
</li>
<li data-nodeid="1612">
<p data-nodeid="1613"><strong data-nodeid="1753">si/so</strong> 显示了交换分区的一些使用情况，交换分区对性能的影响比较大，需要格外关注；</p>
</li>
<li data-nodeid="1614">
<p data-nodeid="1615"><strong data-nodeid="1762">cs</strong> 每秒钟上下文切换（<strong data-nodeid="1763">Context Switch</strong>）的数量，如果上下文切换过于频繁，就需要考虑是否是进程或者线程数开的过多。</p>
</li>
</ul>
<p data-nodeid="1616">每个进程上下文切换的具体数量，可以通过查看内存映射文件获取，如下代码所示：</p>
<pre class="lang-dart" data-nodeid="1617"><code data-language="dart">[root<span class="hljs-meta">@localhost</span> ~]# cat /proc/<span class="hljs-number">2788</span>/status
...
voluntary_ctxt_switches: <span class="hljs-number">93950</span>
nonvoluntary_ctxt_switches: <span class="hljs-number">171204</span>
</code></pre>
<h3 data-nodeid="1618">内存</h3>
<p data-nodeid="1619">要想了解内存对性能的影响，则需要从操作系统层面来看一下内存的分布。</p>
<p data-nodeid="1620"><img src="https://s0.lgstatic.com/i/image/M00/35/7F/Ciqc1F8VdzuABJH4AAC4RXZgIoo881.png" alt="图片1.png" data-nodeid="1769"></p>
<p data-nodeid="1621">我们在平常写完代码后，比如写了一个 C++ 程序，去查看它的汇编，如果看到其中的内存地址，并不是实际的物理内存地址，那么应用程序所使用的，就是<strong data-nodeid="1775">逻辑内存</strong>。学过计算机组成结构的同学应该都有了解。</p>
<p data-nodeid="1622">逻辑地址可以映射到两个内存段上：<strong data-nodeid="1785">物理内存</strong>和<strong data-nodeid="1786">虚拟内存</strong>，那么整个系统可用的内存就是两者之和。比如你的物理内存是 4GB，分配了 8GB 的 SWAP 分区，那么应用可用的总内存就是 12GB。</p>
<h4 data-nodeid="1623">1. top 命令</h4>
<p data-nodeid="1624"><img src="https://s0.lgstatic.com/i/image/M00/35/52/Ciqc1F8VRpyAJEDBAAGXn95jReA806.png" alt="Drawing 4.png" data-nodeid="1792"></p>
<p data-nodeid="1625">如上图所示，我们看一下内存的几个参数，从 top 命令可以看到几列数据，注意方块框起来的三个区域，解释如下：</p>
<ul data-nodeid="1626">
<li data-nodeid="1627">
<p data-nodeid="1628"><strong data-nodeid="1798">VIRT</strong> 这里是指虚拟内存，一般比较大，不用做过多关注；</p>
</li>
<li data-nodeid="1629">
<p data-nodeid="1630"><strong data-nodeid="1803">RES</strong> 我们平常关注的是这一列的数值，它代表了进程实际占用的内存，平常在做监控时，主要监控的也是这个数值；</p>
</li>
<li data-nodeid="1631">
<p data-nodeid="1632"><strong data-nodeid="1808">SHR</strong> 指的是共享内存，比如可以复用的一些 so 文件等。</p>
</li>
</ul>
<h4 data-nodeid="1633">2. CPU 缓存</h4>
<p data-nodeid="1634">由于 CPU 和内存之间的速度差异非常大，解决方式就是<strong data-nodeid="1817">加入高速缓存</strong>。实际上，这些高速缓存往往会有多层，如下图所示。</p>
<p data-nodeid="1635"><img src="https://s0.lgstatic.com/i/image/M00/35/7F/Ciqc1F8Vd0qAZcrnAACrWqlXWc0083.png" alt="图片2.png" data-nodeid="1820"></p>
<p data-nodeid="1636">Java 有大部分知识点是围绕多线程的，那是因为，如果一个线程的时间片跨越了多个 CPU，那么就会存在同步问题。</p>
<p data-nodeid="1637">在 Java 中，和 CPU 缓存相关的最典型的知识点，就是在并发编程中，针对 Cache line 的<strong data-nodeid="1827">伪共享</strong>（False Sharing）问题。</p>
<p data-nodeid="1638">伪共享指的是在这些高速缓存中，以缓存行为单位进行存储，哪怕你修改了缓存行中一个很小很小的数据，它都会整个刷新。所以，当多线程修改一些变量的值时，如果这些变量都在同一个缓存行里，就会造成频繁刷新，无意中影响彼此的性能。</p>
<p data-nodeid="1639">CPU 的每个核，基本是相同的，我们拿 CPU0 来说，可以通过以下的命令查看它的缓存行大小，这个值一般是 64。</p>
<pre class="lang-dart" data-nodeid="1640"><code data-language="dart">cat /sys/devices/system/cpu/cpu0/cache/index0/coherency_line_size
cat /sys/devices/system/cpu/cpu0/cache/index1/coherency_line_size
cat /sys/devices/system/cpu/cpu0/cache/index2/coherency_line_size
cat /sys/devices/system/cpu/cpu0/cache/index3/coherency_line_size
</code></pre>
<p data-nodeid="1641">当然，通过 cpuinfo 也能得到一样的结果：</p>
<pre class="lang-dart" data-nodeid="1642"><code data-language="dart"># cat /proc/cpuinfo | grep cache
cache size	: <span class="hljs-number">20480</span> KB
cache_alignment	: <span class="hljs-number">64</span>
cache size	: <span class="hljs-number">20480</span> KB
cache_alignment	: <span class="hljs-number">64</span>
cache size	: <span class="hljs-number">20480</span> KB
cache_alignment	: <span class="hljs-number">64</span>
cache size	: <span class="hljs-number">20480</span> KB
cache_alignment	: <span class="hljs-number">64</span>
</code></pre>
<p data-nodeid="1643">在 JDK8 以上的版本，通过开启参数 -XX:-RestrictContended，就可以使用注解 @sun.misc.Contended 进行补齐，来避免伪共享的问题。具体情况，在 12 课时并行优化中，我们再详细讲解。</p>
<h4 data-nodeid="1644">3. HugePage</h4>
<p data-nodeid="1645"><img src="https://s0.lgstatic.com/i/image/M00/35/8A/CgqCHl8Vd1SAVNobAACyxjKDIxk345.png" alt="图片3.png" data-nodeid="1837"></p>
<p data-nodeid="1646">我们再回顾一下上文提到的这张图，上面有一个 TLB 组件，它的速度很快，但容量有限，在普通的 PC 机上没有什么瓶颈。但如果机器配置比较高，物理内存比较大，那就会产生非常多的映射表，CPU 的检索效率也会随之降低。</p>
<p data-nodeid="1647">传统的页大小是 4KB，在大内存时代这个值偏小了，解决的办法就是增加页的尺寸，比如将其增加到 2MB，这样，就可以使用较少的映射表来管理大内存。而这种将页增大的技术，就是 <strong data-nodeid="1844">Huge Page</strong>。</p>
<p data-nodeid="1648"><img src="https://s0.lgstatic.com/i/image/M00/35/8A/CgqCHl8Vd1-AVCnzAADX6l8HGwo687.png" alt="图片4.png" data-nodeid="1847"></p>
<p data-nodeid="1649">同时，HugePage 也伴随着一些副作用，比如竞争加剧，但在一些大内存的机器上，开启后在一定程度上会增加性能。</p>
<h4 data-nodeid="1650">4. 预先加载</h4>
<p data-nodeid="1651">另外，一些程序的默认行为也会对性能有所影响，比如 JVM 的 -XX:+AlwaysPreTouch 参数。</p>
<p data-nodeid="1652">默认情况下，JVM 虽然配置了 Xmx、Xms 等参数，指定堆的初始化大小和最大大小，但它的内存在真正用到时，才会分配；但如果加上 AlwaysPreTouch 这个参数，JVM 会在启动的时候，就把所有的内存预先分配。</p>
<p data-nodeid="1653">这样，启动时虽然慢了些，但运行时的性能会增加。</p>
<h3 data-nodeid="1654">I/O</h3>
<p data-nodeid="1655">I/O 设备可能是计算机里速度最慢的组件了，它指的不仅仅是硬盘，还包括外围的所有设备。那硬盘有多慢呢？我们不去探究不同设备的实现细节，直接看它的写入速度（数据未经过严格测试，仅作参考）。</p>
<p data-nodeid="1656"><img src="https://s0.lgstatic.com/i/image/M00/35/52/Ciqc1F8VRxaAK34SAAHTZp7R44c733.png" alt="Drawing 8.png" data-nodeid="1859"></p>
<p data-nodeid="1657">如上图所示，可以看到普通磁盘的随机写与顺序写相差非常大，但顺序写与 CPU 内存依旧不在一个数量级上。</p>
<p data-nodeid="1658"><strong data-nodeid="1865">缓冲区依然是解决速度差异的唯一工具</strong>，但在极端情况下，比如断电时，就产生了太多的不确定性，这时这些缓冲区，都容易丢。由于这部分内容的篇幅比较大，我将在第 06 课时专门讲解。</p>
<h4 data-nodeid="1659">1. iostat</h4>
<p data-nodeid="1660">最能体现 I/O 繁忙程度的，就是 top 命令和 vmstat 命令中的 wa%。如果你的应用写了大量的日志，I/O wait 就可能非常高。</p>
<p data-nodeid="1661"><img src="https://s0.lgstatic.com/i/image/M00/35/5E/CgqCHl8VRzqALt_DAASmJQkN7Ro492.png" alt="Drawing 9.png" data-nodeid="1872"></p>
<p data-nodeid="1662">很多同学反馈到，不知道有哪些便捷好用的查看磁盘 I/O 的工具，其实 iostat 就是。你可以通过 sysstat 包进行安装。</p>
<p data-nodeid="1663"><img src="https://s0.lgstatic.com/i/image/M00/35/5E/CgqCHl8VR0KARZVeAAWCFxfk75s510.png" alt="Drawing 10.png" data-nodeid="1876"></p>
<p data-nodeid="1664">上图中的指标详细介绍如下所示。</p>
<ul data-nodeid="1665">
<li data-nodeid="1666">
<p data-nodeid="1667"><strong data-nodeid="1882">%util</strong>：我们非常关注这个数值，通常情况下，这个数字超过 80%，就证明 I/O 的负荷已经非常严重了。</p>
</li>
<li data-nodeid="1668">
<p data-nodeid="1669"><strong data-nodeid="1887">Device</strong>：表示是哪块硬盘，如果你有多块磁盘，则会显示多行。</p>
</li>
<li data-nodeid="1670">
<p data-nodeid="1671"><strong data-nodeid="1892">avgqu-sz</strong>：平均请求队列的长度，这和十字路口排队的汽车也非常类似。显然，这个值越小越好。</p>
</li>
<li data-nodeid="1672">
<p data-nodeid="1673"><strong data-nodeid="1897">awai</strong>：响应时间包含了队列时间和服务时间，它有一个经验值。通常情况下应该是小于 5ms 的，如果这个值超过了 10ms，则证明等待的时间过长了。</p>
</li>
<li data-nodeid="1674">
<p data-nodeid="1675"><strong data-nodeid="1902">svctm</strong>：表示操作 I/O 的平均服务时间。你可以回忆一下第 01 课时的内容，在这里就是 AVG 的意思。svctm 和 await 是强相关的，如果它们比较接近，则表示 I/O 几乎没有等待，设备的性能很好；但如果 await 比 svctm 的值高出很多，则证明 I/O 的队列等待时间太长，进而系统上运行的应用程序将变慢。</p>
</li>
</ul>
<h4 data-nodeid="1676">2. 零拷贝</h4>
<p data-nodeid="1677">硬盘上的数据，在发往网络之前，需要经过多次缓冲区的拷贝，以及用户空间和内核空间的多次切换。如果能减少一些拷贝的过程，效率就能提升，所以零拷贝应运而生。</p>
<p data-nodeid="1678"><strong data-nodeid="1911">零拷贝</strong>是一种非常重要的性能优化手段，比如常见的 Kafka、Nginx 等，就使用了这种技术。我们来看一下有无零拷贝之间的区别。</p>
<p data-nodeid="1679">（1）没有采取零拷贝手段</p>
<p data-nodeid="1680">如下图所示，传统方式中要想将一个文件的内容通过 Socket 发送出去，则需要经过以下步骤：</p>
<ul data-nodeid="1681">
<li data-nodeid="1682">
<p data-nodeid="1683">将文件内容拷贝到内核空间；</p>
</li>
<li data-nodeid="1684">
<p data-nodeid="1685">将内核空间内存的内容，拷贝到用户空间内存，比如 Java 应用读取 zip 文件；</p>
</li>
<li data-nodeid="1686">
<p data-nodeid="1687">用户空间将内容写入到内核空间的缓存中；</p>
</li>
<li data-nodeid="1688">
<p data-nodeid="1689">Socket 读取内核缓存中的内容，发送出去。</p>
</li>
</ul>
<p data-nodeid="1690"><img src="https://s0.lgstatic.com/i/image/M00/35/8A/CgqCHl8Vd26APrVIAAB4D39Hu4g101.png" alt="图片5.png" data-nodeid="1920"><br>
没有采取零拷贝手段的图</p>
<p data-nodeid="1691">（2）采取了零拷贝手段</p>
<p data-nodeid="1692">零拷贝有多种模式，我们用 sendfile 来举例。如下图所示，在内核的支持下，零拷贝少了一个步骤，那就是内核缓存向用户空间的拷贝，这样既节省了内存，也节省了 CPU 的调度时间，让效率更高。</p>
<p data-nodeid="1693"><img src="https://s0.lgstatic.com/i/image/M00/35/7F/Ciqc1F8Vd36AermYAACHMXg2gv0583.png" alt="图片6.png" data-nodeid="1927"><br>
采取了零拷贝手段的图</p>
<h3 data-nodeid="1694">小结</h3>
<p data-nodeid="1695">本课时我们学习了计算机中对性能影响最大的三个组件：CPU、内存、I/O，并深入了解了观测它们性能的一些命令，这些方式可以帮我们大体猜测性能问题发生的地方。</p>
<p data-nodeid="1696">但它们对性能问题，只能起到辅助作用，不能帮助我们精准地定位至真正的性能瓶颈，还需要做更多深入的排查工作，收集更多信息。</p>
<p data-nodeid="75701" class="">最后留一个思考题：磁盘的速度这么慢，为什么 Kafka 操作磁盘，吞吐量还能那么高？你可以先在留言区讨论，下一课时我会讲解。</p>






































































<p data-nodeid="65536" class="">不知你在实际的工作中是否还有其他的疑惑，欢迎留言讨论，我会一一解答~</p>























<p data-nodeid="1698" class="">在接下来的第 04 课时，我将介绍一系列更深入的工具，帮你获取性能数据，离“病灶”更近一步。</p>

---

### 精选评论

##### **9125：
> Kafka采用了顺序写、零拷贝技术、大量内存页，减少io读写

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 很不错，还有批量处理、异步和pull模式的影响

##### *振：
> 共享内存，虚拟内存，物理内存，逻辑内存，SWAP分区，老师，讲讲这几个定义和关系？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 先来实际有空间的：
- 物理内存：机器的配置，比如4GB
- 虚拟内存：划一块磁盘充当内存，格式就是SWAP。它能当内存用但并不是内存
- 机器的可用内存=物理内存+虚拟内存

再来虚的：
- 共享内存：可以被多个进程共享的内存。比如加载到内存的libjvm.so，可以被多个虚拟机使用，不用每个加载一份
- 逻辑内存：和程序运行有关，和内存占用无关。就是使用硬件，将二进制中的逻辑内存（一份exe的逻辑地址都是固定的），翻译成实际的可用内存

##### **方：
> kafka对磁盘操作是顺序读写，顺序读写操作要比随机读写速度快很多，再加上使用零拷贝技术所以其吞吐量非常高。

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 很棒。学习kafka能够获取很多优化经验，主要有5点。
1. Cache | Filesystem Cache PageCache缓存 
2. 顺序读写  由于现代的操作系统提供了预读和写技术，磁盘的顺序写大多数情况下比随机写内存还要快。
3. Zero-copy 零拷⻉，少了一次内存交换。
4. Batching of Messages 批量量处理。合并小的请求，然后以流的方式进行交互，直顶网络上限。
5. Pull 拉模式 使用拉模式进行消息的获取消费，与消费端处理能力相符。

##### **辉：
> 希望有一些，性能测试优化的实例！分析+定位+优化

##### Howe：
> 老师好，请问对于CPU、内存、磁盘、用户空间、内核空间等这些知识，有什么书籍推荐吗？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 本质上还是操作系统。理论版本可以直接看《操作系统》，实践方面的找一下Linux的热卖书籍就可以了

##### **勇：
> 在内核的支持下，零拷贝少了一个步骤，那就是内核缓存向用户空间的拷贝 问下零拷贝是怎么实现的，什么场景下要使用零拷贝，什么场景下不能使用零拷贝？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 底层实现，可以参考sendfile函数。典型的应用如netty的zero copy，kafka的文件传输，nginx的大文件传输等。只要你的数据不需要经过二次加工发送出去，都可以使用零拷贝，非常适合下载这种场景。

##### **4562：
> Top中每个值多少是好的，多少又要注意了，这些点一般怎么计算呢

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 正常业务cpu应在90%以下；load超过了cpu数，则负载过高（需要迁移扩容），wa过高（10%之上），可初步判断io问题。sy，si，hi，st，任何一个超过5%，都有问题。

##### **0686：
> 由于 CPU 和内存之间的速度差异非常大，解决方式就是加入高速缓存 那这个高速缓存从硬件上看是由什么构成的呢

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 高速缓存指的是CPU的L1，L2，L3甚至Ln层缓存。CPU缓存离CPU最近，但由于材质（SRAM）比较贵，所以容量很小，比如一级缓存可能只有32KB。在Linux下，可以通过查看 /sys/devices/system/cpu/cpu0/cache 下面的文件，查看高速缓存的配置规格。

##### *晴：
> kafka顺序写，批量写等特点，吞吐量大

##### **用户8537：
> 为什么我使用iostat 和老师使用iostat 的界面不一样呢?

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; iostat在不同的操作系统可能有细微的差别，在一些Unix机器上的表现可能和Linux上的不太一样，但主要的利用率等指标，都是相似的。

##### **生：
> kafka是顺序写

##### **4551：
> 学习了，kafka 采用顺序写磁盘，零拷贝来提升它的吞吐量

##### **7324：
> 干货满满 ，收获颇大，帮我们监控系统的重要参数给罗列出来了

##### **飞：
> 将文件内容拷贝到内核空间；--老师，请问从哪拷贝到内核空间？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 文件当然在磁盘上，一般值得是open和read函数。

##### *言：
> 是因为用了零拷贝吗？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 参见其他留言，主要有5点

##### *仔：
> 机械硬盘、ssd、内存的读写速度的比较数据来源哪？机械硬盘的顺序读写速度比ssd还快？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 已经提示数据有出入了哈，不同的硬件测试结果也不同。但肯定的是，机械硬盘的顺序写，是一定比SSD的随机写快的，我们主要突出的是这一点。

##### **鹏：
> 期待老师后续更精彩的课程

##### **鹏：
> 老师分别从CPU、内存、IO讲解了性能指标，以及优化方式。kafka的一次发送到接收流程中，自然会涉及到上述的这些设备交互，再回顾上节课中说到的buffer，page cache不会每次写入都要刷盘，消费时若还在内存中就不用访问磁盘了。还有本节课中说到的顺序写磁盘，io零拷贝加上分区设计与数据压缩都是kafka高吞吐量的重要因素。

